﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultNetworkPlugin.Controls.Strategy;

namespace WinfootDefaultNetworkPlugin.Controls
{
    public partial class DisableIPSourceRouting : UserControl,IControl,ICorrespondenceOS
    {
        private DisableIPSourceRoutingController disableIPSourceRoutingController;

        public DisableIPSourceRouting()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
            
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.migiside.net/wiki/doku.php?id=plugin:network:disableipsourcerouting"));
                userHelp.Show();
            }
        }

        public void SetDisableIPSourceRoutingValue(int i)
        {
            switch (i)
            {
                case 0:
                    radioButton1.Checked = true;
                    break;
                case 1:
                    radioButton3.Checked = true;
                    break;
                default:
                    radioButton2.Checked = true;
                    break;
            }
        }


        public int GetDisableIPSourceRoutingValue()
        {
            if (radioButton1.Checked)
            {
                return 0;
            }
            if (radioButton2.Checked)
            {
                return 1;
            }
            return 2;
        }

        #region IControl メンバ

        public void Apply()
        {
            disableIPSourceRoutingController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return disableIPSourceRoutingController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void DisableIPSourceRouting_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            disableIPSourceRoutingController = new DisableIPSourceRoutingController(this,
                                                                                      (IDisableIPSourceRoutingStrategy)
                                                                                      wfUtillity.
                                                                                          GetCorrespondenceInstance
                                                                                          (new List<ICorrespondenceOS>
                                                                                               {
                                                                                                   new DisableIPSourceRoutingDefaultStrategy()
                                                                                               }));
            disableIPSourceRoutingController.Read();
        }
    }
}
